package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoEnable(
    ec2: Boolean,
    ecr: Boolean,
    lambda: Optional[Boolean] = Optional.Absent,
    lambdaCode: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AutoEnable = {
    import AutoEnable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AutoEnable
      .builder()
      .ec2(ec2: java.lang.Boolean)
      .ecr(ecr: java.lang.Boolean)
      .optionallyWith(lambda.map(value => value: java.lang.Boolean))(_.lambda)
      .optionallyWith(lambdaCode.map(value => value: java.lang.Boolean))(
        _.lambdaCode
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AutoEnable.ReadOnly =
    zio.aws.inspector2.model.AutoEnable.wrap(buildAwsValue())
}
object AutoEnable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AutoEnable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AutoEnable =
      zio.aws.inspector2.model.AutoEnable(
        ec2,
        ecr,
        lambda.map(value => value),
        lambdaCode.map(value => value)
      )
    def ec2: Boolean
    def ecr: Boolean
    def lambda: Optional[Boolean]
    def lambdaCode: Optional[Boolean]
    def getEc2: ZIO[Any, Nothing, Boolean] = ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, Boolean] = ZIO.succeed(ecr)
    def getLambda: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("lambda", lambda)
    def getLambdaCode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("lambdaCode", lambdaCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AutoEnable
  ) extends zio.aws.inspector2.model.AutoEnable.ReadOnly {
    override val ec2: Boolean = impl.ec2(): Boolean
    override val ecr: Boolean = impl.ecr(): Boolean
    override val lambda: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.lambda())
      .map(value => value: Boolean)
    override val lambdaCode: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaCode())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AutoEnable
  ): zio.aws.inspector2.model.AutoEnable.ReadOnly = new Wrapper(impl)
}
