package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.KmsKeyArn
import scala.jdk.CollectionConverters._
final case class UpdateEncryptionKeyRequest(
    kmsKeyId: KmsKeyArn,
    resourceType: zio.aws.inspector2.model.ResourceType,
    scanType: zio.aws.inspector2.model.ScanType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest = {
    import UpdateEncryptionKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest
      .builder()
      .kmsKeyId(KmsKeyArn.unwrap(kmsKeyId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .scanType(scanType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateEncryptionKeyRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateEncryptionKeyRequest.wrap(buildAwsValue())
}
object UpdateEncryptionKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateEncryptionKeyRequest =
      zio.aws.inspector2.model
        .UpdateEncryptionKeyRequest(kmsKeyId, resourceType, scanType)
    def kmsKeyId: KmsKeyArn
    def resourceType: zio.aws.inspector2.model.ResourceType
    def scanType: zio.aws.inspector2.model.ScanType
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyArn] = ZIO.succeed(kmsKeyId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScanType: ZIO[Any, Nothing, zio.aws.inspector2.model.ScanType] =
      ZIO.succeed(scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest
  ) extends zio.aws.inspector2.model.UpdateEncryptionKeyRequest.ReadOnly {
    override val kmsKeyId: KmsKeyArn =
      zio.aws.inspector2.model.primitives.KmsKeyArn(impl.kmsKeyId())
    override val resourceType: zio.aws.inspector2.model.ResourceType =
      zio.aws.inspector2.model.ResourceType.wrap(impl.resourceType())
    override val scanType: zio.aws.inspector2.model.ScanType =
      zio.aws.inspector2.model.ScanType.wrap(impl.scanType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest
  ): zio.aws.inspector2.model.UpdateEncryptionKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
