package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.ResourceStringInput
import scala.jdk.CollectionConverters._
final case class ResourceStringFilter(
    comparison: zio.aws.inspector2.model.ResourceStringComparison,
    value: ResourceStringInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceStringFilter = {
    import ResourceStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceStringFilter
      .builder()
      .comparison(comparison.unwrap)
      .value(ResourceStringInput.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceStringFilter.ReadOnly =
    zio.aws.inspector2.model.ResourceStringFilter.wrap(buildAwsValue())
}
object ResourceStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceStringFilter =
      zio.aws.inspector2.model.ResourceStringFilter(comparison, value)
    def comparison: zio.aws.inspector2.model.ResourceStringComparison
    def value: ResourceStringInput
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceStringComparison] =
      ZIO.succeed(comparison)
    def getValue: ZIO[Any, Nothing, ResourceStringInput] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStringFilter
  ) extends zio.aws.inspector2.model.ResourceStringFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.ResourceStringComparison =
      zio.aws.inspector2.model.ResourceStringComparison.wrap(impl.comparison())
    override val value: ResourceStringInput =
      zio.aws.inspector2.model.primitives.ResourceStringInput(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceStringFilter
  ): zio.aws.inspector2.model.ResourceStringFilter.ReadOnly = new Wrapper(impl)
}
