package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceDetails(
    awsEc2Instance: Optional[zio.aws.inspector2.model.AwsEc2InstanceDetails] =
      Optional.Absent,
    awsEcrContainerImage: Optional[
      zio.aws.inspector2.model.AwsEcrContainerImageDetails
    ] = Optional.Absent,
    awsLambdaFunction: Optional[
      zio.aws.inspector2.model.AwsLambdaFunctionDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceDetails
      .builder()
      .optionallyWith(awsEc2Instance.map(value => value.buildAwsValue()))(
        _.awsEc2Instance
      )
      .optionallyWith(awsEcrContainerImage.map(value => value.buildAwsValue()))(
        _.awsEcrContainerImage
      )
      .optionallyWith(awsLambdaFunction.map(value => value.buildAwsValue()))(
        _.awsLambdaFunction
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceDetails.ReadOnly =
    zio.aws.inspector2.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceDetails =
      zio.aws.inspector2.model.ResourceDetails(
        awsEc2Instance.map(value => value.asEditable),
        awsEcrContainerImage.map(value => value.asEditable),
        awsLambdaFunction.map(value => value.asEditable)
      )
    def awsEc2Instance
        : Optional[zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly]
    def awsEcrContainerImage: Optional[
      zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly
    ]
    def awsLambdaFunction
        : Optional[zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly]
    def getAwsEc2Instance: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEc2Instance", awsEc2Instance)
    def getAwsEcrContainerImage: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsEcrContainerImage", awsEcrContainerImage)
    def getAwsLambdaFunction: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsLambdaFunction", awsLambdaFunction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ) extends zio.aws.inspector2.model.ResourceDetails.ReadOnly {
    override val awsEc2Instance
        : Optional[zio.aws.inspector2.model.AwsEc2InstanceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsEc2Instance())
        .map(value =>
          zio.aws.inspector2.model.AwsEc2InstanceDetails.wrap(value)
        )
    override val awsEcrContainerImage: Optional[
      zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsEcrContainerImage())
      .map(value =>
        zio.aws.inspector2.model.AwsEcrContainerImageDetails.wrap(value)
      )
    override val awsLambdaFunction
        : Optional[zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLambdaFunction())
        .map(value =>
          zio.aws.inspector2.model.AwsLambdaFunctionDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceDetails
  ): zio.aws.inspector2.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
