package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters._
final case class CancelSbomExportRequest(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest = {
    import CancelSbomExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CancelSbomExportRequest.ReadOnly =
    zio.aws.inspector2.model.CancelSbomExportRequest.wrap(buildAwsValue())
}
object CancelSbomExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CancelSbomExportRequest =
      zio.aws.inspector2.model.CancelSbomExportRequest(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest
  ) extends zio.aws.inspector2.model.CancelSbomExportRequest.ReadOnly {
    override val reportId: ReportId =
      zio.aws.inspector2.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest
  ): zio.aws.inspector2.model.CancelSbomExportRequest.ReadOnly = new Wrapper(
    impl
  )
}
