package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FindingArn
import scala.jdk.CollectionConverters._
final case class BatchGetCodeSnippetRequest(findingArns: Iterable[FindingArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest = {
    import BatchGetCodeSnippetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest
      .builder()
      .findingArns(findingArns.map { item =>
        FindingArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.BatchGetCodeSnippetRequest.ReadOnly =
    zio.aws.inspector2.model.BatchGetCodeSnippetRequest.wrap(buildAwsValue())
}
object BatchGetCodeSnippetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetCodeSnippetRequest =
      zio.aws.inspector2.model.BatchGetCodeSnippetRequest(findingArns)
    def findingArns: List[FindingArn]
    def getFindingArns: ZIO[Any, Nothing, List[FindingArn]] =
      ZIO.succeed(findingArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest
  ) extends zio.aws.inspector2.model.BatchGetCodeSnippetRequest.ReadOnly {
    override val findingArns: List[FindingArn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.FindingArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest
  ): zio.aws.inspector2.model.BatchGetCodeSnippetRequest.ReadOnly = new Wrapper(
    impl
  )
}
