package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateConfigurationRequest(
    ecrConfiguration: zio.aws.inspector2.model.EcrConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest = {
    import UpdateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
      .builder()
      .ecrConfiguration(ecrConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateConfigurationRequest.wrap(buildAwsValue())
}
object UpdateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateConfigurationRequest =
      zio.aws.inspector2.model
        .UpdateConfigurationRequest(ecrConfiguration.asEditable)
    def ecrConfiguration: zio.aws.inspector2.model.EcrConfiguration.ReadOnly
    def getEcrConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.inspector2.model.EcrConfiguration.ReadOnly
    ] = ZIO.succeed(ecrConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ) extends zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly {
    override val ecrConfiguration
        : zio.aws.inspector2.model.EcrConfiguration.ReadOnly =
      zio.aws.inspector2.model.EcrConfiguration.wrap(impl.ecrConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest
  ): zio.aws.inspector2.model.UpdateConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
