package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait TitleSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.TitleSortBy
}
object TitleSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.TitleSortBy
  ): zio.aws.inspector2.model.TitleSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.TitleSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.TitleSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.TitleSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.TitleSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.TitleSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TitleSortBy =
      software.amazon.awssdk.services.inspector2.model.TitleSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.TitleSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TitleSortBy =
      software.amazon.awssdk.services.inspector2.model.TitleSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.TitleSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TitleSortBy =
      software.amazon.awssdk.services.inspector2.model.TitleSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.TitleSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.TitleSortBy =
      software.amazon.awssdk.services.inspector2.model.TitleSortBy.ALL
  }
}
