package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait Ec2DeepInspectionStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus
}
object Ec2DeepInspectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus
  ): zio.aws.inspector2.model.Ec2DeepInspectionStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.Ec2DeepInspectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVATED
      extends zio.aws.inspector2.model.Ec2DeepInspectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.ACTIVATED
  }
  case object DEACTIVATED
      extends zio.aws.inspector2.model.Ec2DeepInspectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.DEACTIVATED
  }
  case object PENDING extends zio.aws.inspector2.model.Ec2DeepInspectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.PENDING
  }
  case object FAILED extends zio.aws.inspector2.model.Ec2DeepInspectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus =
      software.amazon.awssdk.services.inspector2.model.Ec2DeepInspectionStatus.FAILED
  }
}
