package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class MemberAccountEc2DeepInspectionStatus(
    accountId: AccountId,
    activateDeepInspection: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus = {
    import MemberAccountEc2DeepInspectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .activateDeepInspection(activateDeepInspection: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly =
    zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus
      .wrap(buildAwsValue())
}
object MemberAccountEc2DeepInspectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus =
      zio.aws.inspector2.model
        .MemberAccountEc2DeepInspectionStatus(accountId, activateDeepInspection)
    def accountId: AccountId
    def activateDeepInspection: Boolean
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getActivateDeepInspection: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(activateDeepInspection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus
  ) extends zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val activateDeepInspection: Boolean =
      impl.activateDeepInspection(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.MemberAccountEc2DeepInspectionStatus
  ): zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly =
    new Wrapper(impl)
}
