package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  CisaDateDue,
  CisaDateAdded,
  CisaAction
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CisaData(
    action: Optional[CisaAction] = Optional.Absent,
    dateAdded: Optional[CisaDateAdded] = Optional.Absent,
    dateDue: Optional[CisaDateDue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CisaData = {
    import CisaData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CisaData
      .builder()
      .optionallyWith(
        action.map(value => CisaAction.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        dateAdded.map(value => CisaDateAdded.unwrap(value): Instant)
      )(_.dateAdded)
      .optionallyWith(dateDue.map(value => CisaDateDue.unwrap(value): Instant))(
        _.dateDue
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CisaData.ReadOnly =
    zio.aws.inspector2.model.CisaData.wrap(buildAwsValue())
}
object CisaData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CisaData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CisaData =
      zio.aws.inspector2.model.CisaData(
        action.map(value => value),
        dateAdded.map(value => value),
        dateDue.map(value => value)
      )
    def action: Optional[CisaAction]
    def dateAdded: Optional[CisaDateAdded]
    def dateDue: Optional[CisaDateDue]
    def getAction: ZIO[Any, AwsError, CisaAction] =
      AwsError.unwrapOptionField("action", action)
    def getDateAdded: ZIO[Any, AwsError, CisaDateAdded] =
      AwsError.unwrapOptionField("dateAdded", dateAdded)
    def getDateDue: ZIO[Any, AwsError, CisaDateDue] =
      AwsError.unwrapOptionField("dateDue", dateDue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CisaData
  ) extends zio.aws.inspector2.model.CisaData.ReadOnly {
    override val action: Optional[CisaAction] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.inspector2.model.primitives.CisaAction(value))
    override val dateAdded: Optional[CisaDateAdded] = zio.aws.core.internal
      .optionalFromNullable(impl.dateAdded())
      .map(value => zio.aws.inspector2.model.primitives.CisaDateAdded(value))
    override val dateDue: Optional[CisaDateDue] = zio.aws.core.internal
      .optionalFromNullable(impl.dateDue())
      .map(value => zio.aws.inspector2.model.primitives.CisaDateDue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CisaData
  ): zio.aws.inspector2.model.CisaData.ReadOnly = new Wrapper(impl)
}
