package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.Path
import scala.jdk.CollectionConverters._
final case class UpdateOrgEc2DeepInspectionConfigurationRequest(
    orgPackagePaths: Iterable[Path]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest = {
    import UpdateOrgEc2DeepInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
      .builder()
      .orgPackagePaths(orgPackagePaths.map { item =>
        Path.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateOrgEc2DeepInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest =
      zio.aws.inspector2.model
        .UpdateOrgEc2DeepInspectionConfigurationRequest(orgPackagePaths)
    def orgPackagePaths: List[Path]
    def getOrgPackagePaths: ZIO[Any, Nothing, List[Path]] =
      ZIO.succeed(orgPackagePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
  ) extends zio.aws.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest.ReadOnly {
    override val orgPackagePaths: List[Path] = impl
      .orgPackagePaths()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.Path(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
  ): zio.aws.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
