package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait FixAvailable {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FixAvailable
}
object FixAvailable {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FixAvailable
  ): zio.aws.inspector2.model.FixAvailable = value match {
    case software.amazon.awssdk.services.inspector2.model.FixAvailable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FixAvailable.YES =>
      val r = YES
      r
    case software.amazon.awssdk.services.inspector2.model.FixAvailable.NO =>
      val r = NO
      r
    case software.amazon.awssdk.services.inspector2.model.FixAvailable.PARTIAL =>
      val r = PARTIAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FixAvailable =
      software.amazon.awssdk.services.inspector2.model.FixAvailable.UNKNOWN_TO_SDK_VERSION
  }
  case object YES extends zio.aws.inspector2.model.FixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FixAvailable =
      software.amazon.awssdk.services.inspector2.model.FixAvailable.YES
  }
  case object NO extends zio.aws.inspector2.model.FixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FixAvailable =
      software.amazon.awssdk.services.inspector2.model.FixAvailable.NO
  }
  case object PARTIAL extends zio.aws.inspector2.model.FixAvailable {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FixAvailable =
      software.amazon.awssdk.services.inspector2.model.FixAvailable.PARTIAL
  }
}
