package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait ReportFormat {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ReportFormat
}
object ReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ReportFormat
  ): zio.aws.inspector2.model.ReportFormat = value match {
    case software.amazon.awssdk.services.inspector2.model.ReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ReportFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.inspector2.model.ReportFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportFormat =
      software.amazon.awssdk.services.inspector2.model.ReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.inspector2.model.ReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportFormat =
      software.amazon.awssdk.services.inspector2.model.ReportFormat.CSV
  }
  case object JSON extends zio.aws.inspector2.model.ReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ReportFormat =
      software.amazon.awssdk.services.inspector2.model.ReportFormat.JSON
  }
}
