package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait VulnerabilitySource {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.VulnerabilitySource
}
object VulnerabilitySource {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.VulnerabilitySource
  ): zio.aws.inspector2.model.VulnerabilitySource = value match {
    case software.amazon.awssdk.services.inspector2.model.VulnerabilitySource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.VulnerabilitySource.NVD =>
      val r = NVD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.VulnerabilitySource {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.VulnerabilitySource =
      software.amazon.awssdk.services.inspector2.model.VulnerabilitySource.UNKNOWN_TO_SDK_VERSION
  }
  case object NVD extends zio.aws.inspector2.model.VulnerabilitySource {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.VulnerabilitySource =
      software.amazon.awssdk.services.inspector2.model.VulnerabilitySource.NVD
  }
}
