package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class SearchVulnerabilitiesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    vulnerabilities: Iterable[zio.aws.inspector2.model.Vulnerability]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse = {
    import SearchVulnerabilitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .vulnerabilities(vulnerabilities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.SearchVulnerabilitiesResponse.ReadOnly =
    zio.aws.inspector2.model.SearchVulnerabilitiesResponse.wrap(buildAwsValue())
}
object SearchVulnerabilitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SearchVulnerabilitiesResponse =
      zio.aws.inspector2.model.SearchVulnerabilitiesResponse(
        nextToken.map(value => value),
        vulnerabilities.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def vulnerabilities: List[zio.aws.inspector2.model.Vulnerability.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVulnerabilities: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.Vulnerability.ReadOnly
    ]] = ZIO.succeed(vulnerabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse
  ) extends zio.aws.inspector2.model.SearchVulnerabilitiesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val vulnerabilities
        : List[zio.aws.inspector2.model.Vulnerability.ReadOnly] = impl
      .vulnerabilities()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.Vulnerability.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse
  ): zio.aws.inspector2.model.SearchVulnerabilitiesResponse.ReadOnly =
    new Wrapper(impl)
}
