package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait PackageSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.PackageSortBy
}
object PackageSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.PackageSortBy
  ): zio.aws.inspector2.model.PackageSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.PackageSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.PackageSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.PackageSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.PackageSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.PackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageSortBy =
      software.amazon.awssdk.services.inspector2.model.PackageSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.PackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageSortBy =
      software.amazon.awssdk.services.inspector2.model.PackageSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.PackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageSortBy =
      software.amazon.awssdk.services.inspector2.model.PackageSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.PackageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.PackageSortBy =
      software.amazon.awssdk.services.inspector2.model.PackageSortBy.ALL
  }
}
