package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait Runtime {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Runtime
}
object Runtime {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Runtime
  ): zio.aws.inspector2.model.Runtime = value match {
    case software.amazon.awssdk.services.inspector2.model.Runtime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS =>
      val r = NODEJS
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_12_X =>
      val r = NODEJS_12_X
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_14_X =>
      val r = NODEJS_14_X
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_16_X =>
      val r = NODEJS_16_X
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_8 =>
      val r = JAVA_8
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_8_AL2 =>
      val r = JAVA_8_AL2
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_11 =>
      val r = JAVA_11
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_7 =>
      val r = PYTHON_3_7
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_8 =>
      val r = PYTHON_3_8
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_9 =>
      val r = PYTHON_3_9
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.UNSUPPORTED =>
      val r = UNSUPPORTED
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_18_X =>
      val r = NODEJS_18_X
      r
    case software.amazon.awssdk.services.inspector2.model.Runtime.GO_1_X =>
      val r = GO_1_X
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.UNKNOWN_TO_SDK_VERSION
  }
  case object NODEJS extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS
  }
  case object NODEJS_12_X extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_12_X
  }
  case object NODEJS_14_X extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_14_X
  }
  case object NODEJS_16_X extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_16_X
  }
  case object JAVA_8 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_8
  }
  case object JAVA_8_AL2 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_8_AL2
  }
  case object JAVA_11 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.JAVA_11
  }
  case object PYTHON_3_7 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_7
  }
  case object PYTHON_3_8 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_8
  }
  case object PYTHON_3_9 extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.PYTHON_3_9
  }
  case object UNSUPPORTED extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.UNSUPPORTED
  }
  case object NODEJS_18_X extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.NODEJS_18_X
  }
  case object GO_1_X extends zio.aws.inspector2.model.Runtime {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Runtime =
      software.amazon.awssdk.services.inspector2.model.Runtime.GO_1_X
  }
}
