package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait FreeTrialInfoErrorCode {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode
}
object FreeTrialInfoErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode
  ): zio.aws.inspector2.model.FreeTrialInfoErrorCode = value match {
    case software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FreeTrialInfoErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode =
      software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED
      extends zio.aws.inspector2.model.FreeTrialInfoErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode =
      software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.ACCESS_DENIED
  }
  case object INTERNAL_ERROR
      extends zio.aws.inspector2.model.FreeTrialInfoErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode =
      software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorCode.INTERNAL_ERROR
  }
}
