package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceFilterCriteria(
    accountId: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent,
    ec2InstanceTags: Optional[
      Iterable[zio.aws.inspector2.model.ResourceMapFilter]
    ] = Optional.Absent,
    ecrImageTags: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent,
    ecrRepositoryName: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent,
    lambdaFunctionName: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent,
    lambdaFunctionTags: Optional[
      Iterable[zio.aws.inspector2.model.ResourceMapFilter]
    ] = Optional.Absent,
    resourceId: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent,
    resourceType: Optional[
      Iterable[zio.aws.inspector2.model.ResourceStringFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria = {
    import ResourceFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria
      .builder()
      .optionallyWith(
        accountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountId)
      .optionallyWith(
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceTags)
      .optionallyWith(
        ecrImageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageTags)
      .optionallyWith(
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrRepositoryName)
      .optionallyWith(
        lambdaFunctionName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionName)
      .optionallyWith(
        lambdaFunctionTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionTags)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.ResourceFilterCriteria.wrap(buildAwsValue())
}
object ResourceFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceFilterCriteria =
      zio.aws.inspector2.model.ResourceFilterCriteria(
        accountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lambdaFunctionName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lambdaFunctionTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def ec2InstanceTags
        : Optional[List[zio.aws.inspector2.model.ResourceMapFilter.ReadOnly]]
    def ecrImageTags
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def ecrRepositoryName
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def lambdaFunctionName
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def lambdaFunctionTags
        : Optional[List[zio.aws.inspector2.model.ResourceMapFilter.ReadOnly]]
    def resourceId
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def resourceType
        : Optional[List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountId", accountId)
    def getEc2InstanceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceMapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceTags", ec2InstanceTags)
    def getEcrImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageTags", ecrImageTags)
    def getEcrRepositoryName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrRepositoryName", ecrRepositoryName)
    def getLambdaFunctionName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lambdaFunctionName", lambdaFunctionName)
    def getLambdaFunctionTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceMapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lambdaFunctionTags", lambdaFunctionTags)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.ResourceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria
  ) extends zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly {
    override val accountId: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
    override val ec2InstanceTags
        : Optional[List[zio.aws.inspector2.model.ResourceMapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.ResourceMapFilter.wrap(item)
          }.toList
        )
    override val ecrImageTags: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrImageTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
    override val ecrRepositoryName: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrRepositoryName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
    override val lambdaFunctionName: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
    override val lambdaFunctionTags
        : Optional[List[zio.aws.inspector2.model.ResourceMapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaFunctionTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.ResourceMapFilter.wrap(item)
          }.toList
        )
    override val resourceId: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
    override val resourceType: Optional[
      List[zio.aws.inspector2.model.ResourceStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.ResourceStringFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria
  ): zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
