package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SeverityCounts(
    all: Optional[Long] = Optional.Absent,
    critical: Optional[Long] = Optional.Absent,
    high: Optional[Long] = Optional.Absent,
    medium: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.SeverityCounts = {
    import SeverityCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.SeverityCounts
      .builder()
      .optionallyWith(all.map(value => value: java.lang.Long))(_.all)
      .optionallyWith(critical.map(value => value: java.lang.Long))(_.critical)
      .optionallyWith(high.map(value => value: java.lang.Long))(_.high)
      .optionallyWith(medium.map(value => value: java.lang.Long))(_.medium)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.SeverityCounts.ReadOnly =
    zio.aws.inspector2.model.SeverityCounts.wrap(buildAwsValue())
}
object SeverityCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.SeverityCounts =
      zio.aws.inspector2.model.SeverityCounts(
        all.map(value => value),
        critical.map(value => value),
        high.map(value => value),
        medium.map(value => value)
      )
    def all: Optional[Long]
    def critical: Optional[Long]
    def high: Optional[Long]
    def medium: Optional[Long]
    def getAll: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("all", all)
    def getCritical: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("critical", critical)
    def getHigh: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("high", high)
    def getMedium: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("medium", medium)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ) extends zio.aws.inspector2.model.SeverityCounts.ReadOnly {
    override val all: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.all())
      .map(value => value: Long)
    override val critical: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.critical())
      .map(value => value: Long)
    override val high: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.high())
      .map(value => value: Long)
    override val medium: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.medium())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.SeverityCounts
  ): zio.aws.inspector2.model.SeverityCounts.ReadOnly = new Wrapper(impl)
}
