package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ResourceMapFilter(
    comparison: zio.aws.inspector2.model.ResourceMapComparison,
    key: NonEmptyString,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceMapFilter = {
    import ResourceMapFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceMapFilter
      .builder()
      .comparison(comparison.unwrap)
      .key(NonEmptyString.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceMapFilter.ReadOnly =
    zio.aws.inspector2.model.ResourceMapFilter.wrap(buildAwsValue())
}
object ResourceMapFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceMapFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceMapFilter =
      zio.aws.inspector2.model
        .ResourceMapFilter(comparison, key, value.map(value => value))
    def comparison: zio.aws.inspector2.model.ResourceMapComparison
    def key: NonEmptyString
    def value: Optional[NonEmptyString]
    def getComparison
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceMapComparison] =
      ZIO.succeed(comparison)
    def getKey: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceMapFilter
  ) extends zio.aws.inspector2.model.ResourceMapFilter.ReadOnly {
    override val comparison: zio.aws.inspector2.model.ResourceMapComparison =
      zio.aws.inspector2.model.ResourceMapComparison.wrap(impl.comparison())
    override val key: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.key())
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceMapFilter
  ): zio.aws.inspector2.model.ResourceMapFilter.ReadOnly = new Wrapper(impl)
}
