package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetEncryptionKeyRequest(
    resourceType: zio.aws.inspector2.model.ResourceType,
    scanType: zio.aws.inspector2.model.ScanType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest = {
    import ResetEncryptionKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .scanType(scanType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResetEncryptionKeyRequest.ReadOnly =
    zio.aws.inspector2.model.ResetEncryptionKeyRequest.wrap(buildAwsValue())
}
object ResetEncryptionKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResetEncryptionKeyRequest =
      zio.aws.inspector2.model.ResetEncryptionKeyRequest(resourceType, scanType)
    def resourceType: zio.aws.inspector2.model.ResourceType
    def scanType: zio.aws.inspector2.model.ScanType
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScanType: ZIO[Any, Nothing, zio.aws.inspector2.model.ScanType] =
      ZIO.succeed(scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest
  ) extends zio.aws.inspector2.model.ResetEncryptionKeyRequest.ReadOnly {
    override val resourceType: zio.aws.inspector2.model.ResourceType =
      zio.aws.inspector2.model.ResourceType.wrap(impl.resourceType())
    override val scanType: zio.aws.inspector2.model.ScanType =
      zio.aws.inspector2.model.ScanType.wrap(impl.scanType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest
  ): zio.aws.inspector2.model.ResetEncryptionKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
