package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{ReportId, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class GetSbomExportResponse(
    errorCode: Optional[zio.aws.inspector2.model.ReportingErrorCode] =
      Optional.Absent,
    errorMessage: Optional[NonEmptyString] = Optional.Absent,
    filterCriteria: Optional[zio.aws.inspector2.model.ResourceFilterCriteria] =
      Optional.Absent,
    format: Optional[zio.aws.inspector2.model.SbomReportFormat] =
      Optional.Absent,
    reportId: Optional[ReportId] = Optional.Absent,
    s3Destination: Optional[zio.aws.inspector2.model.Destination] =
      Optional.Absent,
    status: Optional[zio.aws.inspector2.model.ExternalReportStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse = {
    import GetSbomExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.GetSbomExportResponse.ReadOnly =
    zio.aws.inspector2.model.GetSbomExportResponse.wrap(buildAwsValue())
}
object GetSbomExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.GetSbomExportResponse =
      zio.aws.inspector2.model.GetSbomExportResponse(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        filterCriteria.map(value => value.asEditable),
        format.map(value => value),
        reportId.map(value => value),
        s3Destination.map(value => value.asEditable),
        status.map(value => value)
      )
    def errorCode: Optional[zio.aws.inspector2.model.ReportingErrorCode]
    def errorMessage: Optional[NonEmptyString]
    def filterCriteria
        : Optional[zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly]
    def format: Optional[zio.aws.inspector2.model.SbomReportFormat]
    def reportId: Optional[ReportId]
    def s3Destination: Optional[zio.aws.inspector2.model.Destination.ReadOnly]
    def status: Optional[zio.aws.inspector2.model.ExternalReportStatus]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ReportingErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SbomReportFormat] =
      AwsError.unwrapOptionField("format", format)
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ExternalReportStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse
  ) extends zio.aws.inspector2.model.GetSbomExportResponse.ReadOnly {
    override val errorCode
        : Optional[zio.aws.inspector2.model.ReportingErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.inspector2.model.ReportingErrorCode.wrap(value))
    override val errorMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.ResourceFilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value =>
          zio.aws.inspector2.model.ResourceFilterCriteria.wrap(value)
        )
    override val format: Optional[zio.aws.inspector2.model.SbomReportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.inspector2.model.SbomReportFormat.wrap(value))
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value => zio.aws.inspector2.model.primitives.ReportId(value))
    override val s3Destination
        : Optional[zio.aws.inspector2.model.Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.inspector2.model.Destination.wrap(value))
    override val status
        : Optional[zio.aws.inspector2.model.ExternalReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.inspector2.model.ExternalReportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse
  ): zio.aws.inspector2.model.GetSbomExportResponse.ReadOnly = new Wrapper(impl)
}
