package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  LambdaLayerArn,
  ExecutionRoleArn,
  Timestamp,
  Version,
  FunctionName,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionDetails(
    architectures: Optional[Iterable[zio.aws.inspector2.model.Architecture]] =
      Optional.Absent,
    codeSha256: NonEmptyString,
    executionRoleArn: ExecutionRoleArn,
    functionName: FunctionName,
    lastModifiedAt: Optional[Timestamp] = Optional.Absent,
    layers: Optional[Iterable[LambdaLayerArn]] = Optional.Absent,
    packageType: Optional[zio.aws.inspector2.model.PackageType] =
      Optional.Absent,
    runtime: zio.aws.inspector2.model.Runtime,
    version: Version,
    vpcConfig: Optional[zio.aws.inspector2.model.LambdaVpcConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails = {
    import AwsLambdaFunctionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails
      .builder()
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architecturesWithStrings)
      .codeSha256(NonEmptyString.unwrap(codeSha256): java.lang.String)
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        lastModifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedAt)
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            LambdaLayerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .runtime(runtime.unwrap)
      .version(Version.unwrap(version): java.lang.String)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly =
    zio.aws.inspector2.model.AwsLambdaFunctionDetails.wrap(buildAwsValue())
}
object AwsLambdaFunctionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AwsLambdaFunctionDetails =
      zio.aws.inspector2.model.AwsLambdaFunctionDetails(
        architectures.map(value => value),
        codeSha256,
        executionRoleArn,
        functionName,
        lastModifiedAt.map(value => value),
        layers.map(value => value),
        packageType.map(value => value),
        runtime,
        version,
        vpcConfig.map(value => value.asEditable)
      )
    def architectures: Optional[List[zio.aws.inspector2.model.Architecture]]
    def codeSha256: NonEmptyString
    def executionRoleArn: ExecutionRoleArn
    def functionName: FunctionName
    def lastModifiedAt: Optional[Timestamp]
    def layers: Optional[List[LambdaLayerArn]]
    def packageType: Optional[zio.aws.inspector2.model.PackageType]
    def runtime: zio.aws.inspector2.model.Runtime
    def version: Version
    def vpcConfig: Optional[zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly]
    def getArchitectures
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Architecture]] =
      AwsError.unwrapOptionField("architectures", architectures)
    def getCodeSha256: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(codeSha256)
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getLastModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedAt", lastModifiedAt)
    def getLayers: ZIO[Any, AwsError, List[LambdaLayerArn]] =
      AwsError.unwrapOptionField("layers", layers)
    def getPackageType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getRuntime: ZIO[Any, Nothing, zio.aws.inspector2.model.Runtime] =
      ZIO.succeed(runtime)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails
  ) extends zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly {
    override val architectures
        : Optional[List[zio.aws.inspector2.model.Architecture]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Architecture.wrap(item)
          }.toList
        )
    override val codeSha256: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.codeSha256())
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.inspector2.model.primitives
        .ExecutionRoleArn(impl.executionRoleArn())
    override val functionName: FunctionName =
      zio.aws.inspector2.model.primitives.FunctionName(impl.functionName())
    override val lastModifiedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedAt())
      .map(value => zio.aws.inspector2.model.primitives.Timestamp(value))
    override val layers: Optional[List[LambdaLayerArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.LambdaLayerArn(item)
        }.toList
      )
    override val packageType: Optional[zio.aws.inspector2.model.PackageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageType())
        .map(value => zio.aws.inspector2.model.PackageType.wrap(value))
    override val runtime: zio.aws.inspector2.model.Runtime =
      zio.aws.inspector2.model.Runtime.wrap(impl.runtime())
    override val version: Version =
      zio.aws.inspector2.model.primitives.Version(impl.version())
    override val vpcConfig
        : Optional[zio.aws.inspector2.model.LambdaVpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.inspector2.model.LambdaVpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsLambdaFunctionDetails
  ): zio.aws.inspector2.model.AwsLambdaFunctionDetails.ReadOnly = new Wrapper(
    impl
  )
}
