package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NetworkReachabilityDetails(
    networkPath: zio.aws.inspector2.model.NetworkPath,
    openPortRange: zio.aws.inspector2.model.PortRange,
    protocol: zio.aws.inspector2.model.NetworkProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails = {
    import NetworkReachabilityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails
      .builder()
      .networkPath(networkPath.buildAwsValue())
      .openPortRange(openPortRange.buildAwsValue())
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly =
    zio.aws.inspector2.model.NetworkReachabilityDetails.wrap(buildAwsValue())
}
object NetworkReachabilityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.NetworkReachabilityDetails =
      zio.aws.inspector2.model.NetworkReachabilityDetails(
        networkPath.asEditable,
        openPortRange.asEditable,
        protocol
      )
    def networkPath: zio.aws.inspector2.model.NetworkPath.ReadOnly
    def openPortRange: zio.aws.inspector2.model.PortRange.ReadOnly
    def protocol: zio.aws.inspector2.model.NetworkProtocol
    def getNetworkPath
        : ZIO[Any, Nothing, zio.aws.inspector2.model.NetworkPath.ReadOnly] =
      ZIO.succeed(networkPath)
    def getOpenPortRange
        : ZIO[Any, Nothing, zio.aws.inspector2.model.PortRange.ReadOnly] =
      ZIO.succeed(openPortRange)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.inspector2.model.NetworkProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails
  ) extends zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly {
    override val networkPath: zio.aws.inspector2.model.NetworkPath.ReadOnly =
      zio.aws.inspector2.model.NetworkPath.wrap(impl.networkPath())
    override val openPortRange: zio.aws.inspector2.model.PortRange.ReadOnly =
      zio.aws.inspector2.model.PortRange.wrap(impl.openPortRange())
    override val protocol: zio.aws.inspector2.model.NetworkProtocol =
      zio.aws.inspector2.model.NetworkProtocol.wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails
  ): zio.aws.inspector2.model.NetworkReachabilityDetails.ReadOnly = new Wrapper(
    impl
  )
}
