package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.{MapValue, MapKey, Arn}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[MapKey, MapValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (MapKey.unwrap(key): java.lang.String) -> (MapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TagResourceRequest.ReadOnly =
    zio.aws.inspector2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TagResourceRequest =
      zio.aws.inspector2.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[MapKey, MapValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[MapKey, MapValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TagResourceRequest
  ) extends zio.aws.inspector2.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.inspector2.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[MapKey, MapValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector2.model.primitives
          .MapKey(key) -> zio.aws.inspector2.model.primitives.MapValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TagResourceRequest
  ): zio.aws.inspector2.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
