package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait AggregationResourceType {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.AggregationResourceType
}
object AggregationResourceType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.AggregationResourceType
  ): zio.aws.inspector2.model.AggregationResourceType = value match {
    case software.amazon.awssdk.services.inspector2.model.AggregationResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_EC2_INSTANCE =>
      val r = AWS_EC2_INSTANCE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_ECR_CONTAINER_IMAGE =>
      val r = AWS_ECR_CONTAINER_IMAGE
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_LAMBDA_FUNCTION =>
      val r = AWS_LAMBDA_FUNCTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.AggregationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationResourceType =
      software.amazon.awssdk.services.inspector2.model.AggregationResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_EC2_INSTANCE
      extends zio.aws.inspector2.model.AggregationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationResourceType =
      software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_EC2_INSTANCE
  }
  case object AWS_ECR_CONTAINER_IMAGE
      extends zio.aws.inspector2.model.AggregationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationResourceType =
      software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_ECR_CONTAINER_IMAGE
  }
  case object AWS_LAMBDA_FUNCTION
      extends zio.aws.inspector2.model.AggregationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationResourceType =
      software.amazon.awssdk.services.inspector2.model.AggregationResourceType.AWS_LAMBDA_FUNCTION
  }
}
