package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceState(
    ec2: zio.aws.inspector2.model.State,
    ecr: zio.aws.inspector2.model.State,
    lambda: Optional[zio.aws.inspector2.model.State] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceState = {
    import ResourceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceState
      .builder()
      .ec2(ec2.buildAwsValue())
      .ecr(ecr.buildAwsValue())
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceState.ReadOnly =
    zio.aws.inspector2.model.ResourceState.wrap(buildAwsValue())
}
object ResourceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceState =
      zio.aws.inspector2.model.ResourceState(
        ec2.asEditable,
        ecr.asEditable,
        lambda.map(value => value.asEditable)
      )
    def ec2: zio.aws.inspector2.model.State.ReadOnly
    def ecr: zio.aws.inspector2.model.State.ReadOnly
    def lambda: Optional[zio.aws.inspector2.model.State.ReadOnly]
    def getEc2: ZIO[Any, Nothing, zio.aws.inspector2.model.State.ReadOnly] =
      ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, zio.aws.inspector2.model.State.ReadOnly] =
      ZIO.succeed(ecr)
    def getLambda: ZIO[Any, AwsError, zio.aws.inspector2.model.State.ReadOnly] =
      AwsError.unwrapOptionField("lambda", lambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceState
  ) extends zio.aws.inspector2.model.ResourceState.ReadOnly {
    override val ec2: zio.aws.inspector2.model.State.ReadOnly =
      zio.aws.inspector2.model.State.wrap(impl.ec2())
    override val ecr: zio.aws.inspector2.model.State.ReadOnly =
      zio.aws.inspector2.model.State.wrap(impl.ecr())
    override val lambda: Optional[zio.aws.inspector2.model.State.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.inspector2.model.State.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceState
  ): zio.aws.inspector2.model.ResourceState.ReadOnly = new Wrapper(impl)
}
