package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters._
final case class LambdaLayerAggregationResponse(
    accountId: AccountId,
    functionName: NonEmptyString,
    layerArn: NonEmptyString,
    resourceId: NonEmptyString,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregationResponse = {
    import LambdaLayerAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregationResponse
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .functionName(NonEmptyString.unwrap(functionName): java.lang.String)
      .layerArn(NonEmptyString.unwrap(layerArn): java.lang.String)
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.LambdaLayerAggregationResponse
      .wrap(buildAwsValue())
}
object LambdaLayerAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.LambdaLayerAggregationResponse =
      zio.aws.inspector2.model.LambdaLayerAggregationResponse(
        accountId,
        functionName,
        layerArn,
        resourceId,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: AccountId
    def functionName: NonEmptyString
    def layerArn: NonEmptyString
    def resourceId: NonEmptyString
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getFunctionName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(functionName)
    def getLayerArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(layerArn)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregationResponse
  ) extends zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val functionName: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.functionName())
    override val layerArn: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.layerArn())
    override val resourceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.resourceId())
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.LambdaLayerAggregationResponse
  ): zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
