package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{NextToken, ListFindingsMaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFindingsRequest(
    filterCriteria: Optional[zio.aws.inspector2.model.FilterCriteria] =
      Optional.Absent,
    maxResults: Optional[ListFindingsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortCriteria: Optional[zio.aws.inspector2.model.SortCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListFindingsRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value => ListFindingsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListFindingsRequest.ReadOnly =
    zio.aws.inspector2.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListFindingsRequest =
      zio.aws.inspector2.model.ListFindingsRequest(
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly]
    def maxResults: Optional[ListFindingsMaxResults]
    def nextToken: Optional[NextToken]
    def sortCriteria: Optional[zio.aws.inspector2.model.SortCriteria.ReadOnly]
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, ListFindingsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingsRequest
  ) extends zio.aws.inspector2.model.ListFindingsRequest.ReadOnly {
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.inspector2.model.FilterCriteria.wrap(value))
    override val maxResults: Optional[ListFindingsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListFindingsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
    override val sortCriteria
        : Optional[zio.aws.inspector2.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.inspector2.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListFindingsRequest
  ): zio.aws.inspector2.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
