package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait EcrScanFrequency {
  def unwrap: software.amazon.awssdk.services.inspector2.model.EcrScanFrequency
}
object EcrScanFrequency {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.EcrScanFrequency
  ): zio.aws.inspector2.model.EcrScanFrequency = value match {
    case software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.MANUAL =>
      val r = MANUAL
      r
    case software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.SCAN_ON_PUSH =>
      val r = SCAN_ON_PUSH
      r
    case software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.CONTINUOUS_SCAN =>
      val r = CONTINUOUS_SCAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.EcrScanFrequency {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrScanFrequency =
      software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object MANUAL extends zio.aws.inspector2.model.EcrScanFrequency {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrScanFrequency =
      software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.MANUAL
  }
  case object SCAN_ON_PUSH extends zio.aws.inspector2.model.EcrScanFrequency {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrScanFrequency =
      software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.SCAN_ON_PUSH
  }
  case object CONTINUOUS_SCAN
      extends zio.aws.inspector2.model.EcrScanFrequency {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.EcrScanFrequency =
      software.amazon.awssdk.services.inspector2.model.EcrScanFrequency.CONTINUOUS_SCAN
  }
}
