package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  FilterReason,
  FilterName,
  FilterArn,
  FilterDescription
}
import scala.jdk.CollectionConverters._
final case class UpdateFilterRequest(
    action: Optional[zio.aws.inspector2.model.FilterAction] = Optional.Absent,
    description: Optional[FilterDescription] = Optional.Absent,
    filterArn: FilterArn,
    filterCriteria: Optional[zio.aws.inspector2.model.FilterCriteria] =
      Optional.Absent,
    name: Optional[FilterName] = Optional.Absent,
    reason: Optional[FilterReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest = {
    import UpdateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .filterArn(FilterArn.unwrap(filterArn): java.lang.String)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        name.map(value => FilterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        reason.map(value => FilterReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly =
    zio.aws.inspector2.model.UpdateFilterRequest.wrap(buildAwsValue())
}
object UpdateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UpdateFilterRequest =
      zio.aws.inspector2.model.UpdateFilterRequest(
        action.map(value => value),
        description.map(value => value),
        filterArn,
        filterCriteria.map(value => value.asEditable),
        name.map(value => value),
        reason.map(value => value)
      )
    def action: Optional[zio.aws.inspector2.model.FilterAction]
    def description: Optional[FilterDescription]
    def filterArn: FilterArn
    def filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly]
    def name: Optional[FilterName]
    def reason: Optional[FilterReason]
    def getAction: ZIO[Any, AwsError, zio.aws.inspector2.model.FilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFilterArn: ZIO[Any, Nothing, FilterArn] = ZIO.succeed(filterArn)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getName: ZIO[Any, AwsError, FilterName] =
      AwsError.unwrapOptionField("name", name)
    def getReason: ZIO[Any, AwsError, FilterReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ) extends zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly {
    override val action: Optional[zio.aws.inspector2.model.FilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.inspector2.model.FilterAction.wrap(value))
    override val description: Optional[FilterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.inspector2.model.primitives.FilterDescription(value)
        )
    override val filterArn: FilterArn =
      zio.aws.inspector2.model.primitives.FilterArn(impl.filterArn())
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.inspector2.model.FilterCriteria.wrap(value))
    override val name: Optional[FilterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.inspector2.model.primitives.FilterName(value))
    override val reason: Optional[FilterReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.inspector2.model.primitives.FilterReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest
  ): zio.aws.inspector2.model.UpdateFilterRequest.ReadOnly = new Wrapper(impl)
}
