package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AggregationRequest(
    accountAggregation: Optional[zio.aws.inspector2.model.AccountAggregation] =
      Optional.Absent,
    amiAggregation: Optional[zio.aws.inspector2.model.AmiAggregation] =
      Optional.Absent,
    awsEcrContainerAggregation: Optional[
      zio.aws.inspector2.model.AwsEcrContainerAggregation
    ] = Optional.Absent,
    ec2InstanceAggregation: Optional[
      zio.aws.inspector2.model.Ec2InstanceAggregation
    ] = Optional.Absent,
    findingTypeAggregation: Optional[
      zio.aws.inspector2.model.FindingTypeAggregation
    ] = Optional.Absent,
    imageLayerAggregation: Optional[
      zio.aws.inspector2.model.ImageLayerAggregation
    ] = Optional.Absent,
    packageAggregation: Optional[zio.aws.inspector2.model.PackageAggregation] =
      Optional.Absent,
    repositoryAggregation: Optional[
      zio.aws.inspector2.model.RepositoryAggregation
    ] = Optional.Absent,
    titleAggregation: Optional[zio.aws.inspector2.model.TitleAggregation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AggregationRequest = {
    import AggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AggregationRequest
      .builder()
      .optionallyWith(accountAggregation.map(value => value.buildAwsValue()))(
        _.accountAggregation
      )
      .optionallyWith(amiAggregation.map(value => value.buildAwsValue()))(
        _.amiAggregation
      )
      .optionallyWith(
        awsEcrContainerAggregation.map(value => value.buildAwsValue())
      )(_.awsEcrContainerAggregation)
      .optionallyWith(
        ec2InstanceAggregation.map(value => value.buildAwsValue())
      )(_.ec2InstanceAggregation)
      .optionallyWith(
        findingTypeAggregation.map(value => value.buildAwsValue())
      )(_.findingTypeAggregation)
      .optionallyWith(
        imageLayerAggregation.map(value => value.buildAwsValue())
      )(_.imageLayerAggregation)
      .optionallyWith(packageAggregation.map(value => value.buildAwsValue()))(
        _.packageAggregation
      )
      .optionallyWith(
        repositoryAggregation.map(value => value.buildAwsValue())
      )(_.repositoryAggregation)
      .optionallyWith(titleAggregation.map(value => value.buildAwsValue()))(
        _.titleAggregation
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AggregationRequest.ReadOnly =
    zio.aws.inspector2.model.AggregationRequest.wrap(buildAwsValue())
}
object AggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AggregationRequest =
      zio.aws.inspector2.model.AggregationRequest(
        accountAggregation.map(value => value.asEditable),
        amiAggregation.map(value => value.asEditable),
        awsEcrContainerAggregation.map(value => value.asEditable),
        ec2InstanceAggregation.map(value => value.asEditable),
        findingTypeAggregation.map(value => value.asEditable),
        imageLayerAggregation.map(value => value.asEditable),
        packageAggregation.map(value => value.asEditable),
        repositoryAggregation.map(value => value.asEditable),
        titleAggregation.map(value => value.asEditable)
      )
    def accountAggregation
        : Optional[zio.aws.inspector2.model.AccountAggregation.ReadOnly]
    def amiAggregation
        : Optional[zio.aws.inspector2.model.AmiAggregation.ReadOnly]
    def awsEcrContainerAggregation
        : Optional[zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly]
    def ec2InstanceAggregation
        : Optional[zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly]
    def findingTypeAggregation
        : Optional[zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly]
    def imageLayerAggregation
        : Optional[zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly]
    def packageAggregation
        : Optional[zio.aws.inspector2.model.PackageAggregation.ReadOnly]
    def repositoryAggregation
        : Optional[zio.aws.inspector2.model.RepositoryAggregation.ReadOnly]
    def titleAggregation
        : Optional[zio.aws.inspector2.model.TitleAggregation.ReadOnly]
    def getAccountAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AccountAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("accountAggregation", accountAggregation)
    def getAmiAggregation
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AmiAggregation.ReadOnly] =
      AwsError.unwrapOptionField("amiAggregation", amiAggregation)
    def getAwsEcrContainerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEcrContainerAggregation",
      awsEcrContainerAggregation
    )
    def getEc2InstanceAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2InstanceAggregation",
      ec2InstanceAggregation
    )
    def getFindingTypeAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "findingTypeAggregation",
      findingTypeAggregation
    )
    def getImageLayerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly
    ] =
      AwsError.unwrapOptionField("imageLayerAggregation", imageLayerAggregation)
    def getPackageAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.PackageAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("packageAggregation", packageAggregation)
    def getRepositoryAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.RepositoryAggregation.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAggregation", repositoryAggregation)
    def getTitleAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.TitleAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("titleAggregation", titleAggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ) extends zio.aws.inspector2.model.AggregationRequest.ReadOnly {
    override val accountAggregation
        : Optional[zio.aws.inspector2.model.AccountAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountAggregation())
        .map(value => zio.aws.inspector2.model.AccountAggregation.wrap(value))
    override val amiAggregation
        : Optional[zio.aws.inspector2.model.AmiAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiAggregation())
        .map(value => zio.aws.inspector2.model.AmiAggregation.wrap(value))
    override val awsEcrContainerAggregation: Optional[
      zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsEcrContainerAggregation())
      .map(value =>
        zio.aws.inspector2.model.AwsEcrContainerAggregation.wrap(value)
      )
    override val ec2InstanceAggregation
        : Optional[zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceAggregation())
        .map(value =>
          zio.aws.inspector2.model.Ec2InstanceAggregation.wrap(value)
        )
    override val findingTypeAggregation
        : Optional[zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingTypeAggregation())
        .map(value =>
          zio.aws.inspector2.model.FindingTypeAggregation.wrap(value)
        )
    override val imageLayerAggregation
        : Optional[zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageLayerAggregation())
        .map(value =>
          zio.aws.inspector2.model.ImageLayerAggregation.wrap(value)
        )
    override val packageAggregation
        : Optional[zio.aws.inspector2.model.PackageAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageAggregation())
        .map(value => zio.aws.inspector2.model.PackageAggregation.wrap(value))
    override val repositoryAggregation
        : Optional[zio.aws.inspector2.model.RepositoryAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryAggregation())
        .map(value =>
          zio.aws.inspector2.model.RepositoryAggregation.wrap(value)
        )
    override val titleAggregation
        : Optional[zio.aws.inspector2.model.TitleAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.titleAggregation())
        .map(value => zio.aws.inspector2.model.TitleAggregation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationRequest
  ): zio.aws.inspector2.model.AggregationRequest.ReadOnly = new Wrapper(impl)
}
