package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.MeteringAccountId
import scala.jdk.CollectionConverters._
final case class FreeTrialInfoError(
    accountId: MeteringAccountId,
    code: zio.aws.inspector2.model.FreeTrialInfoErrorCode,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError = {
    import FreeTrialInfoError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError
      .builder()
      .accountId(MeteringAccountId.unwrap(accountId): java.lang.String)
      .code(code.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly =
    zio.aws.inspector2.model.FreeTrialInfoError.wrap(buildAwsValue())
}
object FreeTrialInfoError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FreeTrialInfoError =
      zio.aws.inspector2.model.FreeTrialInfoError(accountId, code, message)
    def accountId: MeteringAccountId
    def code: zio.aws.inspector2.model.FreeTrialInfoErrorCode
    def message: String
    def getAccountId: ZIO[Any, Nothing, MeteringAccountId] =
      ZIO.succeed(accountId)
    def getCode
        : ZIO[Any, Nothing, zio.aws.inspector2.model.FreeTrialInfoErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError
  ) extends zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly {
    override val accountId: MeteringAccountId =
      zio.aws.inspector2.model.primitives.MeteringAccountId(impl.accountId())
    override val code: zio.aws.inspector2.model.FreeTrialInfoErrorCode =
      zio.aws.inspector2.model.FreeTrialInfoErrorCode.wrap(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError
  ): zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly = new Wrapper(impl)
}
