package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait RelationshipStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.RelationshipStatus
}
object RelationshipStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.RelationshipStatus
  ): zio.aws.inspector2.model.RelationshipStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.INVITED =>
      val r = INVITED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.REMOVED =>
      val r = REMOVED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.RESIGNED =>
      val r = RESIGNED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.EMAIL_VERIFICATION_IN_PROGRESS =>
      val r = EMAIL_VERIFICATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.EMAIL_VERIFICATION_FAILED =>
      val r = EMAIL_VERIFICATION_FAILED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.REGION_DISABLED =>
      val r = REGION_DISABLED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.ACCOUNT_SUSPENDED =>
      val r = ACCOUNT_SUSPENDED
      r
    case software.amazon.awssdk.services.inspector2.model.RelationshipStatus.CANNOT_CREATE_DETECTOR_IN_ORG_MASTER =>
      val r = CANNOT_CREATE_DETECTOR_IN_ORG_MASTER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.CREATED
  }
  case object INVITED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.INVITED
  }
  case object DISABLED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.DISABLED
  }
  case object ENABLED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.ENABLED
  }
  case object REMOVED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.REMOVED
  }
  case object RESIGNED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.RESIGNED
  }
  case object DELETED extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.DELETED
  }
  case object EMAIL_VERIFICATION_IN_PROGRESS
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.EMAIL_VERIFICATION_IN_PROGRESS
  }
  case object EMAIL_VERIFICATION_FAILED
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.EMAIL_VERIFICATION_FAILED
  }
  case object REGION_DISABLED
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.REGION_DISABLED
  }
  case object ACCOUNT_SUSPENDED
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.ACCOUNT_SUSPENDED
  }
  case object CANNOT_CREATE_DETECTOR_IN_ORG_MASTER
      extends zio.aws.inspector2.model.RelationshipStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.RelationshipStatus =
      software.amazon.awssdk.services.inspector2.model.RelationshipStatus.CANNOT_CREATE_DETECTOR_IN_ORG_MASTER
  }
}
