package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait Service {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Service
}
object Service {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Service
  ): zio.aws.inspector2.model.Service = value match {
    case software.amazon.awssdk.services.inspector2.model.Service.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Service.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.inspector2.model.Service.ECR =>
      val r = ECR
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.Service {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Service =
      software.amazon.awssdk.services.inspector2.model.Service.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.inspector2.model.Service {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Service =
      software.amazon.awssdk.services.inspector2.model.Service.EC2
  }
  case object ECR extends zio.aws.inspector2.model.Service {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Service =
      software.amazon.awssdk.services.inspector2.model.Service.ECR
  }
}
