package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EcrConfigurationState(
    rescanDurationState: Optional[
      zio.aws.inspector2.model.EcrRescanDurationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EcrConfigurationState = {
    import EcrConfigurationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EcrConfigurationState
      .builder()
      .optionallyWith(rescanDurationState.map(value => value.buildAwsValue()))(
        _.rescanDurationState
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EcrConfigurationState.ReadOnly =
    zio.aws.inspector2.model.EcrConfigurationState.wrap(buildAwsValue())
}
object EcrConfigurationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EcrConfigurationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EcrConfigurationState =
      zio.aws.inspector2.model.EcrConfigurationState(
        rescanDurationState.map(value => value.asEditable)
      )
    def rescanDurationState
        : Optional[zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly]
    def getRescanDurationState: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly
    ] = AwsError.unwrapOptionField("rescanDurationState", rescanDurationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfigurationState
  ) extends zio.aws.inspector2.model.EcrConfigurationState.ReadOnly {
    override val rescanDurationState
        : Optional[zio.aws.inspector2.model.EcrRescanDurationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rescanDurationState())
        .map(value =>
          zio.aws.inspector2.model.EcrRescanDurationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EcrConfigurationState
  ): zio.aws.inspector2.model.EcrConfigurationState.ReadOnly = new Wrapper(impl)
}
