package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkProtocol {
  def unwrap: software.amazon.awssdk.services.inspector2.model.NetworkProtocol
}
object NetworkProtocol {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.NetworkProtocol
  ): zio.aws.inspector2.model.NetworkProtocol = value match {
    case software.amazon.awssdk.services.inspector2.model.NetworkProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.NetworkProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.inspector2.model.NetworkProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.NetworkProtocol {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.NetworkProtocol =
      software.amazon.awssdk.services.inspector2.model.NetworkProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.inspector2.model.NetworkProtocol {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.NetworkProtocol =
      software.amazon.awssdk.services.inspector2.model.NetworkProtocol.TCP
  }
  case object UDP extends zio.aws.inspector2.model.NetworkProtocol {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.NetworkProtocol =
      software.amazon.awssdk.services.inspector2.model.NetworkProtocol.UDP
  }
}
