package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{ClientToken, AccountId}
import scala.jdk.CollectionConverters._
final case class EnableRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    resourceTypes: Iterable[zio.aws.inspector2.model.ResourceScanType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.EnableRequest = {
    import EnableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.EnableRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .resourceTypesWithStrings(resourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.EnableRequest.ReadOnly =
    zio.aws.inspector2.model.EnableRequest.wrap(buildAwsValue())
}
object EnableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.EnableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.EnableRequest =
      zio.aws.inspector2.model.EnableRequest(
        accountIds.map(value => value),
        clientToken.map(value => value),
        resourceTypes
      )
    def accountIds: Optional[List[AccountId]]
    def clientToken: Optional[ClientToken]
    def resourceTypes: List[zio.aws.inspector2.model.ResourceScanType]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getResourceTypes
        : ZIO[Any, Nothing, List[zio.aws.inspector2.model.ResourceScanType]] =
      ZIO.succeed(resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.EnableRequest
  ) extends zio.aws.inspector2.model.EnableRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.AccountId(item)
        }.toList
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.inspector2.model.primitives.ClientToken(value))
    override val resourceTypes
        : List[zio.aws.inspector2.model.ResourceScanType] = impl
      .resourceTypes()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.ResourceScanType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.EnableRequest
  ): zio.aws.inspector2.model.EnableRequest.ReadOnly = new Wrapper(impl)
}
