package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class CvssScoreDetails(
    adjustments: Optional[
      Iterable[zio.aws.inspector2.model.CvssScoreAdjustment]
    ] = Optional.Absent,
    cvssSource: Optional[NonEmptyString] = Optional.Absent,
    score: Double,
    scoreSource: NonEmptyString,
    scoringVector: NonEmptyString,
    version: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CvssScoreDetails = {
    import CvssScoreDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CvssScoreDetails
      .builder()
      .optionallyWith(
        adjustments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adjustments)
      .optionallyWith(
        cvssSource.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cvssSource)
      .score(score: java.lang.Double)
      .scoreSource(NonEmptyString.unwrap(scoreSource): java.lang.String)
      .scoringVector(NonEmptyString.unwrap(scoringVector): java.lang.String)
      .version(NonEmptyString.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CvssScoreDetails.ReadOnly =
    zio.aws.inspector2.model.CvssScoreDetails.wrap(buildAwsValue())
}
object CvssScoreDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CvssScoreDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CvssScoreDetails =
      zio.aws.inspector2.model.CvssScoreDetails(
        adjustments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cvssSource.map(value => value),
        score,
        scoreSource,
        scoringVector,
        version
      )
    def adjustments
        : Optional[List[zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly]]
    def cvssSource: Optional[NonEmptyString]
    def score: Double
    def scoreSource: NonEmptyString
    def scoringVector: NonEmptyString
    def version: NonEmptyString
    def getAdjustments: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly
    ]] = AwsError.unwrapOptionField("adjustments", adjustments)
    def getCvssSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cvssSource", cvssSource)
    def getScore: ZIO[Any, Nothing, Double] = ZIO.succeed(score)
    def getScoreSource: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(scoreSource)
    def getScoringVector: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(scoringVector)
    def getVersion: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScoreDetails
  ) extends zio.aws.inspector2.model.CvssScoreDetails.ReadOnly {
    override val adjustments: Optional[
      List[zio.aws.inspector2.model.CvssScoreAdjustment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adjustments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CvssScoreAdjustment.wrap(item)
        }.toList
      )
    override val cvssSource: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cvssSource())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val score: Double = impl.score(): Double
    override val scoreSource: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.scoreSource())
    override val scoringVector: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.scoringVector())
    override val version: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CvssScoreDetails
  ): zio.aws.inspector2.model.CvssScoreDetails.ReadOnly = new Wrapper(impl)
}
