package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class Account(
    accountId: AccountId,
    resourceStatus: zio.aws.inspector2.model.ResourceStatus,
    status: zio.aws.inspector2.model.Status
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Account = {
    import Account.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Account
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .resourceStatus(resourceStatus.buildAwsValue())
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Account.ReadOnly =
    zio.aws.inspector2.model.Account.wrap(buildAwsValue())
}
object Account {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Account
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Account = zio.aws.inspector2.model
      .Account(accountId, resourceStatus.asEditable, status)
    def accountId: AccountId
    def resourceStatus: zio.aws.inspector2.model.ResourceStatus.ReadOnly
    def status: zio.aws.inspector2.model.Status
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getResourceStatus
        : ZIO[Any, Nothing, zio.aws.inspector2.model.ResourceStatus.ReadOnly] =
      ZIO.succeed(resourceStatus)
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector2.model.Status] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Account
  ) extends zio.aws.inspector2.model.Account.ReadOnly {
    override val accountId: AccountId =
      zio.aws.inspector2.model.primitives.AccountId(impl.accountId())
    override val resourceStatus
        : zio.aws.inspector2.model.ResourceStatus.ReadOnly =
      zio.aws.inspector2.model.ResourceStatus.wrap(impl.resourceStatus())
    override val status: zio.aws.inspector2.model.Status =
      zio.aws.inspector2.model.Status.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Account
  ): zio.aws.inspector2.model.Account.ReadOnly = new Wrapper(impl)
}
