package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait CoverageStringComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.CoverageStringComparison
}
object CoverageStringComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.CoverageStringComparison
  ): zio.aws.inspector2.model.CoverageStringComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.CoverageStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CoverageStringComparison =
      software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.CoverageStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CoverageStringComparison =
      software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.EQUALS
  }
  case object NOT_EQUALS
      extends zio.aws.inspector2.model.CoverageStringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.CoverageStringComparison =
      software.amazon.awssdk.services.inspector2.model.CoverageStringComparison.NOT_EQUALS
  }
}
