package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  PackageName,
  PackageArchitecture,
  SourceLayerHash,
  PackageVersion,
  FilePath,
  PackageRelease,
  PackageEpoch
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VulnerablePackage(
    arch: Optional[PackageArchitecture] = Optional.Absent,
    epoch: Optional[PackageEpoch] = Optional.Absent,
    filePath: Optional[FilePath] = Optional.Absent,
    fixedInVersion: Optional[PackageVersion] = Optional.Absent,
    name: PackageName,
    packageManager: Optional[zio.aws.inspector2.model.PackageManager] =
      Optional.Absent,
    release: Optional[PackageRelease] = Optional.Absent,
    sourceLayerHash: Optional[SourceLayerHash] = Optional.Absent,
    version: PackageVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.VulnerablePackage = {
    import VulnerablePackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.VulnerablePackage
      .builder()
      .optionallyWith(
        arch.map(value => PackageArchitecture.unwrap(value): java.lang.String)
      )(_.arch)
      .optionallyWith(epoch.map(value => PackageEpoch.unwrap(value): Integer))(
        _.epoch
      )
      .optionallyWith(
        filePath.map(value => FilePath.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        fixedInVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.fixedInVersion)
      .name(PackageName.unwrap(name): java.lang.String)
      .optionallyWith(packageManager.map(value => value.unwrap))(
        _.packageManager
      )
      .optionallyWith(
        release.map(value => PackageRelease.unwrap(value): java.lang.String)
      )(_.release)
      .optionallyWith(
        sourceLayerHash.map(value =>
          SourceLayerHash.unwrap(value): java.lang.String
        )
      )(_.sourceLayerHash)
      .version(PackageVersion.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.VulnerablePackage.ReadOnly =
    zio.aws.inspector2.model.VulnerablePackage.wrap(buildAwsValue())
}
object VulnerablePackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.VulnerablePackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.VulnerablePackage =
      zio.aws.inspector2.model.VulnerablePackage(
        arch.map(value => value),
        epoch.map(value => value),
        filePath.map(value => value),
        fixedInVersion.map(value => value),
        name,
        packageManager.map(value => value),
        release.map(value => value),
        sourceLayerHash.map(value => value),
        version
      )
    def arch: Optional[PackageArchitecture]
    def epoch: Optional[PackageEpoch]
    def filePath: Optional[FilePath]
    def fixedInVersion: Optional[PackageVersion]
    def name: PackageName
    def packageManager: Optional[zio.aws.inspector2.model.PackageManager]
    def release: Optional[PackageRelease]
    def sourceLayerHash: Optional[SourceLayerHash]
    def version: PackageVersion
    def getArch: ZIO[Any, AwsError, PackageArchitecture] =
      AwsError.unwrapOptionField("arch", arch)
    def getEpoch: ZIO[Any, AwsError, PackageEpoch] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getFilePath: ZIO[Any, AwsError, FilePath] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFixedInVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("fixedInVersion", fixedInVersion)
    def getName: ZIO[Any, Nothing, PackageName] = ZIO.succeed(name)
    def getPackageManager
        : ZIO[Any, AwsError, zio.aws.inspector2.model.PackageManager] =
      AwsError.unwrapOptionField("packageManager", packageManager)
    def getRelease: ZIO[Any, AwsError, PackageRelease] =
      AwsError.unwrapOptionField("release", release)
    def getSourceLayerHash: ZIO[Any, AwsError, SourceLayerHash] =
      AwsError.unwrapOptionField("sourceLayerHash", sourceLayerHash)
    def getVersion: ZIO[Any, Nothing, PackageVersion] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.VulnerablePackage
  ) extends zio.aws.inspector2.model.VulnerablePackage.ReadOnly {
    override val arch: Optional[PackageArchitecture] = zio.aws.core.internal
      .optionalFromNullable(impl.arch())
      .map(value =>
        zio.aws.inspector2.model.primitives.PackageArchitecture(value)
      )
    override val epoch: Optional[PackageEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.epoch())
      .map(value => zio.aws.inspector2.model.primitives.PackageEpoch(value))
    override val filePath: Optional[FilePath] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.inspector2.model.primitives.FilePath(value))
    override val fixedInVersion: Optional[PackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixedInVersion())
        .map(value => zio.aws.inspector2.model.primitives.PackageVersion(value))
    override val name: PackageName =
      zio.aws.inspector2.model.primitives.PackageName(impl.name())
    override val packageManager
        : Optional[zio.aws.inspector2.model.PackageManager] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageManager())
        .map(value => zio.aws.inspector2.model.PackageManager.wrap(value))
    override val release: Optional[PackageRelease] = zio.aws.core.internal
      .optionalFromNullable(impl.release())
      .map(value => zio.aws.inspector2.model.primitives.PackageRelease(value))
    override val sourceLayerHash: Optional[SourceLayerHash] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLayerHash())
        .map(value =>
          zio.aws.inspector2.model.primitives.SourceLayerHash(value)
        )
    override val version: PackageVersion =
      zio.aws.inspector2.model.primitives.PackageVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.VulnerablePackage
  ): zio.aws.inspector2.model.VulnerablePackage.ReadOnly = new Wrapper(impl)
}
