package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters._
final case class CancelFindingsReportResponse(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse = {
    import CancelFindingsReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly =
    zio.aws.inspector2.model.CancelFindingsReportResponse.wrap(buildAwsValue())
}
object CancelFindingsReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CancelFindingsReportResponse =
      zio.aws.inspector2.model.CancelFindingsReportResponse(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse
  ) extends zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly {
    override val reportId: ReportId =
      zio.aws.inspector2.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse
  ): zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly =
    new Wrapper(impl)
}
