package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait DelegatedAdminStatus {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus
}
object DelegatedAdminStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus
  ): zio.aws.inspector2.model.DelegatedAdminStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.DISABLE_IN_PROGRESS =>
      val r = DISABLE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.DelegatedAdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus =
      software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.inspector2.model.DelegatedAdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus =
      software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.ENABLED
  }
  case object DISABLE_IN_PROGRESS
      extends zio.aws.inspector2.model.DelegatedAdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus =
      software.amazon.awssdk.services.inspector2.model.DelegatedAdminStatus.DISABLE_IN_PROGRESS
  }
}
