package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageLayerAggregation(
    layerHashes: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    repositories: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    resourceIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.ImageLayerSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation = {
    import ImageLayerAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
      .builder()
      .optionallyWith(
        layerHashes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layerHashes)
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly =
    zio.aws.inspector2.model.ImageLayerAggregation.wrap(buildAwsValue())
}
object ImageLayerAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ImageLayerAggregation =
      zio.aws.inspector2.model.ImageLayerAggregation(
        layerHashes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def layerHashes
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def repositories
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.ImageLayerSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getLayerHashes: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("layerHashes", layerHashes)
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getResourceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.ImageLayerSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ) extends zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly {
    override val layerHashes
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layerHashes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val repositories
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[zio.aws.inspector2.model.ImageLayerSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.ImageLayerSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation
  ): zio.aws.inspector2.model.ImageLayerAggregation.ReadOnly = new Wrapper(impl)
}
