package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{UsageValue, MonthlyCostEstimate}
import scala.jdk.CollectionConverters._
final case class Usage(
    currency: Optional[zio.aws.inspector2.model.Currency] = Optional.Absent,
    estimatedMonthlyCost: Optional[MonthlyCostEstimate] = Optional.Absent,
    total: Optional[UsageValue] = Optional.Absent,
    `type`: Optional[zio.aws.inspector2.model.UsageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Usage = {
    import Usage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Usage
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        estimatedMonthlyCost.map(value =>
          MonthlyCostEstimate.unwrap(value): java.lang.Double
        )
      )(_.estimatedMonthlyCost)
      .optionallyWith(
        total.map(value => UsageValue.unwrap(value): java.lang.Double)
      )(_.total)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Usage.ReadOnly =
    zio.aws.inspector2.model.Usage.wrap(buildAwsValue())
}
object Usage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector2.model.Usage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Usage =
      zio.aws.inspector2.model.Usage(
        currency.map(value => value),
        estimatedMonthlyCost.map(value => value),
        total.map(value => value),
        `type`.map(value => value)
      )
    def currency: Optional[zio.aws.inspector2.model.Currency]
    def estimatedMonthlyCost: Optional[MonthlyCostEstimate]
    def total: Optional[UsageValue]
    def `type`: Optional[zio.aws.inspector2.model.UsageType]
    def getCurrency: ZIO[Any, AwsError, zio.aws.inspector2.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getEstimatedMonthlyCost: ZIO[Any, AwsError, MonthlyCostEstimate] =
      AwsError.unwrapOptionField("estimatedMonthlyCost", estimatedMonthlyCost)
    def getTotal: ZIO[Any, AwsError, UsageValue] =
      AwsError.unwrapOptionField("total", total)
    def getType: ZIO[Any, AwsError, zio.aws.inspector2.model.UsageType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Usage
  ) extends zio.aws.inspector2.model.Usage.ReadOnly {
    override val currency: Optional[zio.aws.inspector2.model.Currency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.inspector2.model.Currency.wrap(value))
    override val estimatedMonthlyCost: Optional[MonthlyCostEstimate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedMonthlyCost())
        .map(value =>
          zio.aws.inspector2.model.primitives.MonthlyCostEstimate(value)
        )
    override val total: Optional[UsageValue] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => zio.aws.inspector2.model.primitives.UsageValue(value))
    override val `type`: Optional[zio.aws.inspector2.model.UsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.inspector2.model.UsageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Usage
  ): zio.aws.inspector2.model.Usage.ReadOnly = new Wrapper(impl)
}
