package zio.aws.inspector2.model
import scala.jdk.CollectionConverters._
sealed trait GroupKey {
  def unwrap: software.amazon.awssdk.services.inspector2.model.GroupKey
}
object GroupKey {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.GroupKey
  ): zio.aws.inspector2.model.GroupKey = value match {
    case software.amazon.awssdk.services.inspector2.model.GroupKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.GroupKey.SCAN_STATUS_CODE =>
      val r = SCAN_STATUS_CODE
      r
    case software.amazon.awssdk.services.inspector2.model.GroupKey.SCAN_STATUS_REASON =>
      val r = SCAN_STATUS_REASON
      r
    case software.amazon.awssdk.services.inspector2.model.GroupKey.ACCOUNT_ID =>
      val r = ACCOUNT_ID
      r
    case software.amazon.awssdk.services.inspector2.model.GroupKey.RESOURCE_TYPE =>
      val r = RESOURCE_TYPE
      r
    case software.amazon.awssdk.services.inspector2.model.GroupKey.ECR_REPOSITORY_NAME =>
      val r = ECR_REPOSITORY_NAME
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.UNKNOWN_TO_SDK_VERSION
  }
  case object SCAN_STATUS_CODE extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.SCAN_STATUS_CODE
  }
  case object SCAN_STATUS_REASON extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.SCAN_STATUS_REASON
  }
  case object ACCOUNT_ID extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.ACCOUNT_ID
  }
  case object RESOURCE_TYPE extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.RESOURCE_TYPE
  }
  case object ECR_REPOSITORY_NAME extends zio.aws.inspector2.model.GroupKey {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.GroupKey =
      software.amazon.awssdk.services.inspector2.model.GroupKey.ECR_REPOSITORY_NAME
  }
}
