package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{
  MapValue,
  MapKey,
  NonEmptyString,
  AmiId
}
import scala.jdk.CollectionConverters._
final case class Ec2InstanceAggregationResponse(
    accountId: Optional[String] = Optional.Absent,
    ami: Optional[AmiId] = Optional.Absent,
    instanceId: NonEmptyString,
    instanceTags: Optional[Map[MapKey, MapValue]] = Optional.Absent,
    networkFindings: Optional[Long] = Optional.Absent,
    operatingSystem: Optional[String] = Optional.Absent,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse = {
    import Ec2InstanceAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(ami.map(value => AmiId.unwrap(value): java.lang.String))(
        _.ami
      )
      .instanceId(NonEmptyString.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        instanceTags.map(value =>
          value
            .map({ case (key, value) =>
              (MapKey.unwrap(key): java.lang.String) -> (MapValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.instanceTags)
      .optionallyWith(networkFindings.map(value => value: java.lang.Long))(
        _.networkFindings
      )
      .optionallyWith(operatingSystem.map(value => value: java.lang.String))(
        _.operatingSystem
      )
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.Ec2InstanceAggregationResponse
      .wrap(buildAwsValue())
}
object Ec2InstanceAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2InstanceAggregationResponse =
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse(
        accountId.map(value => value),
        ami.map(value => value),
        instanceId,
        instanceTags.map(value => value),
        networkFindings.map(value => value),
        operatingSystem.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[String]
    def ami: Optional[AmiId]
    def instanceId: NonEmptyString
    def instanceTags: Optional[Map[MapKey, MapValue]]
    def networkFindings: Optional[Long]
    def operatingSystem: Optional[String]
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAmi: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("ami", ami)
    def getInstanceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(instanceId)
    def getInstanceTags: ZIO[Any, AwsError, Map[MapKey, MapValue]] =
      AwsError.unwrapOptionField("instanceTags", instanceTags)
    def getNetworkFindings: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("networkFindings", networkFindings)
    def getOperatingSystem: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ) extends zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val ami: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.ami())
      .map(value => zio.aws.inspector2.model.primitives.AmiId(value))
    override val instanceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.instanceId())
    override val instanceTags: Optional[Map[MapKey, MapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.inspector2.model.primitives.MapKey(
                key
              ) -> zio.aws.inspector2.model.primitives.MapValue(value)
            })
            .toMap
        )
    override val networkFindings: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.networkFindings())
      .map(value => value: Long)
    override val operatingSystem: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operatingSystem())
      .map(value => value: String)
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregationResponse
  ): zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
